<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Cards extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'filename' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
        ]);
        $this->forge->addKey('id', TRUE);
        $this->forge->createTable('cards');
    }

    public function down()
    {
        $this->forge->dropTable('cards');
    }
}
